/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.tags.ITag;

public abstract class TaggedChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements ChemicalStackIngredient<CHEMICAL, STACK> {
    @Nonnull
    private final ITag<CHEMICAL> tag;
    private final long amount;

    protected TaggedChemicalStackIngredient(@Nonnull ChemicalTags<CHEMICAL> tags, @Nonnull TagKey<CHEMICAL> tag, long amount) {
        this(tags.getManager().map(manager -> manager.getTag(tag)).orElseThrow(), amount);
    }

    protected TaggedChemicalStackIngredient(@Nonnull ITag<CHEMICAL> tag, long amount) {
        this.tag = tag;
        this.amount = amount;
    }

    protected abstract ChemicalIngredientInfo<CHEMICAL, STACK> getIngredientInfo();

    @Override
    public boolean test(@Nonnull STACK chemicalStack) {
        return this.testType((CHEMICAL)chemicalStack) && ((ChemicalStack)chemicalStack).getAmount() >= this.amount;
    }

    @Override
    public boolean testType(@Nonnull STACK chemicalStack) {
        return this.testType((CHEMICAL)((ChemicalStack)Objects.requireNonNull(chemicalStack)).getType());
    }

    @Override
    public boolean testType(@Nonnull CHEMICAL chemical) {
        return this.tag.contains((Object)((Chemical)Objects.requireNonNull(chemical)));
    }

    @Override
    @Nonnull
    public STACK getMatchingInstance(@Nonnull STACK chemicalStack) {
        if (this.test(chemicalStack)) {
            return this.getIngredientInfo().createStack(chemicalStack, this.amount);
        }
        return this.getIngredientInfo().getEmptyStack();
    }

    @Override
    public long getNeededAmount(@Nonnull STACK stack) {
        return this.testType((CHEMICAL)stack) ? this.amount : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return this.tag.isEmpty();
    }

    @Override
    @Nonnull
    public List<@NonNull STACK> getRepresentations() {
        ChemicalIngredientInfo<CHEMICAL, Chemical> ingredientInfo = this.getIngredientInfo();
        ArrayList<@NonNull Chemical> representations = new ArrayList<Chemical>();
        for (Chemical chemical : this.tag) {
            representations.add(ingredientInfo.createStack(chemical, this.amount));
        }
        return representations;
    }

    public Iterable<CHEMICAL> getRawInput() {
        return this.tag;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)ChemicalIngredientDeserializer.IngredientType.TAGGED);
        buffer.m_130085_(this.tag.getKey().f_203868_());
        buffer.m_130103_(this.amount);
    }

    @Override
    @Nonnull
    public JsonElement serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("amount", (Number)this.amount);
        json.addProperty("tag", this.tag.getKey().f_203868_().toString());
        return json;
    }
}

